Rem AnimationEncyclopedia.vbs
Rem An InDesign VBScript
Rem 
Rem Author:  Brenda Burden
Rem Creates a 6-page sample doc demonstrating the new InDesign Animation feature

Rem  Search Reference
Rem  PAGE ONE - Sample of Animation Properties 
Rem  PAGE TWO - Sample of all Animation Events
Rem  PAGE THREE - Sample of Additional Animation Properties and Settings, including Duration, Play count, Loop, Speed and Origin
Rem  PAGE FOUR - Sample of Animate To, Animate From, To Current location
Rem  PAGE FIVE - Sample of creating Timing Groups, setting Delays, and looping a Timing Group
Rem  PAGE SIX - Complex A-B-C-D animation that can be created only through scripting (cannot be created in the UI)
main
function main()
	Set myInDesign = CreateObject("InDesign.Application.2021")
	Set myDocument = myInDesign.documents.add
	mySetUnits myInDesign, idMeasurementUnits.idInches
	myDocument.transparencyPreferences.blendingSpace = idBlendingSpace.idRGB
	myDocument.documentPreferences.facingPages = false
	myDocument.documentPreferences.pageWidth = 11.111
	myDocument.documentPreferences.pageHeight = 8.333
	Set myRed = myMakeColor(myInDesign, "Red", idColorSpace.idRGB, idColorModel.idProcess, Array(255, 0, 0))
	Set myGreen = myMakeColor(myInDesign, "Green", idColorSpace.idRGB, idColorModel.idProcess, Array(0, 255, 0))
	Set myBlue = myMakeColor(myInDesign, "Blue", idColorSpace.idRGB, idColorModel.idProcess, Array(0, 0, 255))
	Set myPurple = myMakeColor(myInDesign, "Purple", idColorSpace.idRGB, idColorModel.idProcess, Array(200, 0, 255))
	Set myLightGray = myMakeColor(myInDesign, "Light Gray", idColorSpace.idRGB, idColorModel.idProcess, Array(200, 200, 200))
	Set myNoneSwatch = myDocument.swatches.item("None")
	Rem 
	Rem Page 1
	Rem 
	Rem Create a motion path using motionPathPoints. This is similar to drawing a regular path using the
	Rem entirePath property. If you wish to set keyframes to correspond to points in the path, use motionPath 
	Rem instead of motionPathPoints. See example on Page 6.
	mySetUnits myInDesign, idMeasurementUnits.idPoints
	myMotionPath = Array(Array(Array(Array(0,0),Array(0,0),Array(0,0)),Array(Array(565, 0),Array(565, 0),Array(565, 0)) ),true)
	myCurvedMotionPath = Array(Array(Array(Array(0,0),Array(0,0),Array(0,0)),Array(Array(565,0),Array(565,-150),Array(565,0)) ),true) 
	mySetUnits myInDesign, idMeasurementUnits.idInches
	Rem Create a background rectangle.
	myMakeRectangle myDocument.pages.item(1), Array(0,0,8.333,11.111), "Background Rectangle", myLightGray, myNoneSwatch, 0
	Rem Create a headline text frame.
	myMakeTextFrame myInDesign, myDocument.pages.item(1), Array(.25,0,1,11.111), "Animation Properties", "Myriad Pro", 28, idJustification.idCenterAlign, False
	Rem Add text labels.
	myMakeTextFrame myInDesign, myDocument.pages.item(1), Array(1.25,1,1.625,10.5), "Motion Path", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(1), Array(2.25,1,2.625,10.5), "Rotation", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(1), Array(3.25,1,3.625,10.5), "Opacity", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(1), Array(4.25,1,4.625,10.5), "Scale", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(1), Array(5.25,1,5.625,10.5), "Combination", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(1), Array(6.25,1,6.625,10.5), "Color Fade", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(1), Array(7.25,1,7.625,10.5), "Motion Path with Curve", "Myriad Pro", 18, idJustification.idLeftAlign, True
	Rem Add rectangles.
	Set myRectangle1P1 = myMakeRectangle(myDocument.pages.item(1), Array(1.625,1,2,2), "Motion Path Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle2P1 = myMakeRectangle(myDocument.pages.item(1), Array(2.625,1,3,2), "Rotation Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle3P1 = myMakeRectangle(myDocument.pages.item(1), Array(3.625,1,4,2), "Opacity Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle4P1 = myMakeRectangle(myDocument.pages.item(1), Array(4.625,1,5,2), "Scale Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle5P1 = myMakeRectangle(myDocument.pages.item(1), Array(5.625,1,6,2), "Combination Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle6P1 = myMakeRectangle(myDocument.pages.item(1), Array(6.625,1,7,2), "Color Fade Rectangle Blue", myBlue, myNoneSwatch, 0)
	Set myRectangle7P1 = myMakeRectangle(myDocument.pages.item(1), Array(6.625,1,7,2), "Color Fade Rectangle Purple", myPurple, myNoneSwatch, 0)
	Set myRectangle8P1 = myMakeRectangle(myDocument.pages.item(1), Array(7.625,1,8,2), "Motion Path with Curve Rectangle", myPurple, myNoneSwatch, 0)
	Rem Add animation properties.
	myRectangle1P1.animationSettings.motionPathPoints = myMotionPath
	myRectangle2P1.animationSettings.motionPathPoints = myMotionPath
	myRectangle2P1.animationSettings.rotationArray = Array(Array(0, 0), Array(23, 270))
	myRectangle3P1.animationSettings.motionPathPoints = myMotionPath
	myRectangle3P1.animationSettings.opacityArray = Array(Array(0,100),Array(23,10))  
	myRectangle4P1.animationSettings.motionPathPoints = myMotionPath
	myRectangle4P1.animationSettings.scaleXArray = Array(Array(0,100),Array(23,20))  
	myRectangle4P1.animationSettings.scaleYArray = Array(Array(0,100.0),Array(23,20))  
	myRectangle5P1.animationSettings.motionPathPoints = myMotionPath
	myRectangle5P1.animationSettings.scaleXArray = Array(Array(0,100),Array(23,120))  
	myRectangle5P1.animationSettings.scaleYArray = Array(Array(0,100),Array(23,10))  
	myRectangle5P1.animationSettings.rotationArray = Array(Array(0,0),Array(23,-270))  
	myRectangle5P1.animationSettings.opacityArray = Array(Array(0,100),Array(23,25))  
	myRectangle6P1.animationSettings.motionPathPoints = myMotionPath
	myRectangle6P1.animationSettings.opacityArray = Array(Array(0,0),Array(23,100)) 
	myRectangle7P1.animationSettings.motionPathPoints = myMotionPath
	myRectangle7P1.animationSettings.opacityArray = Array(Array(0,100),Array(23, 50)) 
	myRectangle8P1.animationSettings.motionPathPoints = myCurvedMotionPath
	Set myPageOneTimingSettings = myDocument.spreads.item(1).timingSettings
	Rem Remove the default On Page Load timing list.
	myPageOneTimingSettings.timingLists.item(1).delete
	Rem Add an On Page Click timing list.
	Set p1TimingOnPageClickList = myPageOneTimingSettings.timingLists.add(idDynamicTriggerEvents.idOnPageClick)
	Rem Add Animations as separate On Page Click Timing Groups
	Set p1timingGroup1 = p1TimingOnPageClickList.timingGroups.add(myRectangle1P1, 0)
	Set p1timingGroup2 = p1TimingOnPageClickList.timingGroups.add(myRectangle2P1, 0) 
	Set p1timingGroup3 = p1TimingOnPageClickList.timingGroups.add(myRectangle3P1, 0) 
	Set p1timingGroup4 = p1TimingOnPageClickList.timingGroups.add(myRectangle4P1, 0) 
	Set p1timingGroup5 = p1TimingOnPageClickList.timingGroups.add(myRectangle5P1, 0) 
	Set p1timingGroup6 = p1TimingOnPageClickList.timingGroups.add(myRectangle6P1, 0) 
	Rem Link Rectangle 6 and 7
	p1timingGroup6.timingTargets.add myRectangle7P1,0
	Set p1timingGroup7 = p1TimingOnPageClickList.timingGroups.add(myRectangle8P1, 0)
	Rem 
	Rem Page 2
	Rem 
	Set myMotionPreset = myInDesign.MotionPresets.Item("twirl")
	myDocument.Pages.Add
	Rem Create a background rectangle.
	myMakeRectangle myDocument.Pages.Item(2), Array(0,0,8.333,11.111), "Background Rectangle", myLightGray, myNoneSwatch, 0
	Rem Create a headline text frame.
	myMakeTextFrame myInDesign, myDocument.pages.item(2), Array(.25,0,1,11.111), "Animation Events", "Myriad Pro", 28, idJustification.idCenterAlign, False
	Rem Add text labels.
	myMakeTextFrame myInDesign, myDocument.pages.item(2), Array(1.25,1,1.625,10.5), "On Page Load", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(2), Array(2.25,1,2.625,10.5), "On Page Click", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(2), Array(3.25,1,3.625,10.5), "On Click (Self)", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(2), Array(4.25,1,4.625,10.5), "On Roll Over (Self)", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(2), Array(5.25,1,5.625,10.5), "On Button Event (On Click)", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(2), Array(6.25,1,6.625,10.5), "On State Load of Multi-State Object", "Myriad Pro", 18, idJustification.idLeftAlign, True
	Rem Add rectangles.
	Set myRectangle1P2 = myMakeRectangle(myDocument.pages.item(2), Array(1.625,1,2,2), "On Page Load Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle2P2 = myMakeRectangle(myDocument.pages.item(2), Array(2.625,1,3,2), "On Page Click Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle3P2 = myMakeRectangle(myDocument.pages.item(2), Array(3.625,1,4,2), "Self Click Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle4P2 = myMakeRectangle(myDocument.pages.item(2), Array(4.625,1,5,2), "Self Roll Over Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle5P2 = myMakeRectangle(myDocument.pages.item(2), Array(5.625,1,6,2), "On Button Event (On Click) Rectangle", myPurple, myNoneSwatch, 0)
	Rem Apply the motion preset to the rectangles.
	myRectangle1P2.AnimationSettings.Preset = myMotionPreset
	myRectangle2P2.AnimationSettings.Preset = myMotionPreset
	myRectangle3P2.AnimationSettings.Preset = myMotionPreset
	myRectangle4P2.AnimationSettings.Preset = myMotionPreset
	myRectangle5P2.AnimationSettings.Preset = myMotionPreset
	Rem Add a button to control the animation of myRectangle5P2.
	Set myPlayAnimationButton = myDocument.Pages.Item(2).Buttons.Add
	myPlayAnimationButton.GeometricBounds = Array(5.625,3,6,4)
	myPlayAnimationButton.Name = "Play Animation Button"
	myPlayAnimationButton.FillColor = myGreen
	myPlayAnimationButton.StrokeColor = myNoneSwatch
	Set myAnimationBehavior = myPlayAnimationButton.AnimationBehaviors.Add
	myAnimationBehavior.BehaviorEvent = idBehaviorEvents.idMouseDown
	myAnimationBehavior.EnableBehavior = True
	myAnimationBehavior.AnimatedPageItem = myRectangle5P2
	myAnimationBehavior.Operation = idAnimationPlayOperations.idPlay
	Rem Add a Multi-State Object (MSO).
	Set myMSO = myDocument.Pages.Item(2).multiStateObjects.add
	myMSO.GeometricBounds = Array(6.625,1,7,2)
	myMSO.Name = "Simple MSO"
	myMSO.InitiallyHidden = True
	Rem Name default states.
	myMSO.states.item(1).Name = "Top State"
	Set myTopState = myMSO.States.Item(1)
	myMSO.states.item(2).Name = "Second State"
	Set mySecondState = myMSO.States.Item(2)
	Set myThirdState = myMSO.States.Add
	myThirdState.Name = "Third State"
	Rem Add page items to the states.
	Set myRectangleMSO = myMakeRectangle(myTopState, Array(6.625,1,7,2), "Top State Rectangle", myPurple, myNoneSwatch, 0)
	myRectangleMSO.AnimationSettings.Preset = myMotionPreset
	Set myOvalMSO = myMakeRectangle(mySecondState, Array(6.625,1,7,2), "Second State Oval", myPurple, myNoneSwatch, 0)
	myOvalMSO.ConvertShape idConvertShapeOptions.idConvertToOval
	myOvalMSO.AnimationSettings.Preset = myMotionPreset
	Set myPolygonMSO = myMakeRectangle(myThirdState, Array(6.625,1,7,2), "Third State Polygon", myPurple, myNoneSwatch, 0)
	myPolygonMSO.ConvertShape idConvertShapeOptions.idConvertToPolygon
	myPolygonMSO.AnimationSettings.Preset = myMotionPreset
	Rem Add a button to control the animation of myMSO.
	Set myPlayMSOButton = myDocument.pages.item(2).buttons.add
	myPlayMSOButton.GeometricBounds = Array(6.625,3,7,4)
	myPlayMSOButton.Name = "Go to Next State of MSO Button"
	myPlayMSOButton.FillColor = myGreen
	myPlayMSOButton.StrokeColor = myNoneSwatch
	Set myMSOBehavior = myPlayMSOButton.GotoNextStateBehaviors.Add
	myMSOBehavior.AssociatedMultiStateObject = myMSO
	myMSOBehavior.LoopsToNextOrPrevious = True
	myMSOBehavior.BehaviorEvent = idBehaviorEvents.idMouseDown
	Rem Page 2 timing section:
	Set mySecondSpreadTimingSettings = myDocument.spreads.item(2).timingSettings
	Rem Remove the default timing list.
	mySecondSpreadTimingSettings.TimingLists.Item(1).Delete
	Rem Create On Page Load
	Set mySecondPageLoadTimingList = mySecondSpreadTimingSettings.TimingLists.add(idDynamicTriggerEvents.idOnPageLoad)
	Set secondSpreadTimingG1 = mySecondPageLoadTimingList.TimingGroups.Add(myRectangle1P2, 0)
	Rem Create On Page Click
	Set mySecondPageClickTimingList = mySecondSpreadTimingSettings.TimingLists.add(idDynamicTriggerEvents.idOnPageClick)
	Set secondSpreadTimingG2 = mySecondPageClickTimingList.TimingGroups.Add(myRectangle2P2, 0)
	Rem Create Self Click
	Set myRectangle3P2TimingList = myRectangle3P2.TimingSettings.TimingLists.Add(idDynamicTriggerEvents.idOnSelfClick)
	Rem Create Self Roll Over
	Set myRectangle4P2TimingList = myRectangle4P2.TimingSettings.TimingLists.Add(idDynamicTriggerEvents.idOnSelfRollover)	
	Rem 
	Rem Page 3
	Rem 
	myDocument.Pages.Add
	Rem Create a background rectangle.
	myMakeRectangle myDocument.Pages.Item(3), Array(0,0,8.333,11.111), "Background Rectangle", myLightGray, myNoneSwatch, 0
	Rem Create a headline text frame.
	myMakeTextFrame myInDesign, myDocument.pages.item(3), Array(.25,0,1,11.111), "Additional Animation Properties and Settings", "Myriad Pro", 28, idJustification.idCenterAlign, False
	Rem Add text labels.
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(1.25,1,1.625,10.5), "Duration: 2 seconds", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(2.25,1,2.625,10.5), "Duration: .5 seconds", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(3.25,1,3.625,10.5), "Speed: Ease In", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(4.25,1,4.625,10.5), "Speed: Ease Out", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(5.25,1,5.625,10.5), "Speed: Ease In and Out", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(6.25,1,6.625,10.5), "Play Twice", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(7.25,1,7.625,10.5), "Loop", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(1.25,5,1.625,10.5), "Hide Until Animated", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(2.25,5,2.625,10.5), "Hide After Animating", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(3.25,5,3.625,10.5), "Origin Upper Left Corner", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(4.25,5,4.625,10.5), "Origin Right, Vertical Center", "Myriad Pro", 18, idJustification.idLeftAlign, True
	Rem Add rectangles.
	Set myRectangle1P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(1.625,1,2,2), "2-Second Duration Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle2P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(2.625,1,3,2), ".5 Second Duration Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle3P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(3.625,1,4,2), "Ease In Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle4P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(4.625,1,5,2), "Ease Out Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle5P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(5.625,1,6,2), "Ease In and Out Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle6P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(6.625,1,7,2), "Play Twice Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle7P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(7.625,1,8,2), "Loop Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle8P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(1.625,5,2,6), "Hide Until Animated Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle9P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(2.625,5,3,6), "Hide After Animated Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle10P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(3.625,5,4,6), "Origin Upper Left Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle11P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(4.625,5,5,6), "Origin Right Center Rectangle", myPurple, myNoneSwatch, 0)
	Rem Set animation properties.
	myRectangle1P3.AnimationSettings.Duration = 2
	myRectangle1P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle2P3.AnimationSettings.Duration = 0.5
	myRectangle2P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(11,180))
	myRectangle3P3.AnimationSettings.Duration = 2
	myRectangle3P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle3P3.AnimationSettings.EaseType = idAnimationEaseOptions.idEaseIn
	myRectangle4P3.AnimationSettings.Duration = 2
	myRectangle4P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle4P3.AnimationSettings.EaseType = idAnimationEaseOptions.idEaseOut
	myRectangle5P3.AnimationSettings.Duration = 2
	myRectangle5P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle5P3.AnimationSettings.EaseType = idAnimationEaseOptions.idEaseInOut
	myRectangle6P3.AnimationSettings.Duration = 2
	myRectangle6P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle6P3.AnimationSettings.Plays = 2
	myRectangle7P3.AnimationSettings.Duration = 2
	myRectangle7P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle7P3.AnimationSettings.PlaysLoop = True
	myRectangle8P3.AnimationSettings.Duration = 2
	myRectangle8P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle8P3.AnimationSettings.InitiallyHidden = True
	myRectangle8P3.AnimationSettings.HiddenAfter = False
	myRectangle9P3.AnimationSettings.Duration = 2
	myRectangle9P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle9P3.AnimationSettings.InitiallyHidden = False
	myRectangle9P3.AnimationSettings.HiddenAfter = True
	myRectangle10P3.AnimationSettings.Duration = 2
	myRectangle10P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle10P3.AnimationSettings.TransformOffsets = Array(0, 0)
	myRectangle11P3.AnimationSettings.Duration = 2
	myRectangle11P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle11P3.AnimationSettings.TransformOffsets = Array(1.0,0.5)
	Rem 
	Rem Page 4
	Rem 
	myDocument.Pages.Add
	Rem Create a background rectangle.
	myMakeRectangle myDocument.Pages.Item(4), Array(0,0,8.333,11.111), "Background Rectangle", myLightGray, myNoneSwatch, 0
	Rem Create a headline text frame.
	myMakeTextFrame myInDesign, myDocument.Pages.Item(4), Array(.25,0,1,11.111), "Animate Options", "Myriad Pro", 28, idJustification.idCenterAlign, false
	Rem Add text labels.
	myMakeTextFrame myInDesign, myDocument.Pages.Item(4), Array(1.25,1,1.625,10.5), "Animate: From Current Appearance", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(4), Array(2.25,1,2.625,10.5), "Animate: To Current Appearance", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(4), Array(3.25,1,3.625,10.5), "Animate: To Current Location", "Myriad Pro", 18, idJustification.idLeftAlign, True
	Rem Add rectangles.
	Set myRectangle1P4 = myMakeRectangle(myDocument.Pages.Item(4), Array(1.625,1,2,2), "Animate From Current Appearance", myPurple, myNoneSwatch, 0)
	Set myRectangle2P4 = myMakeRectangle(myDocument.Pages.Item(4), Array(2.625,1,3,2), "Animate To Current Appearance", myPurple, myNoneSwatch, 0)
	set myRectangle3P4 = myMakeRectangle(myDocument.Pages.Item(4), Array(3.625,1,4,2), "Animate To Current Location", myPurple, myNoneSwatch, 0)
	Rem Set animation properties.
	myRectangle1P4.AnimationSettings.Preset = myInDesign.MotionPresets.Item("move-right-grow")
	myRectangle1P4.AnimationSettings.DesignOption = idDesignOptions.idFromCurrentAppearance
	myRectangle2P4.AnimationSettings.Preset =  myInDesign.MotionPresets.Item("move-right-grow")
	myRectangle2P4.AnimationSettings.DesignOption = idDesignOptions.idToCurrentAppearance
	myRectangle3P4.AnimationSettings.Preset = myInDesign.MotionPresets.Item("fly-in-left")
	Rem 
	Rem Page 5
	Rem 
	myDocument.Pages.Add
	Rem Create a background rectangle.
	myMakeRectangle myDocument.Pages.Item(5), Array(0,0,8.333,11.111), "Background Rectangle", myLightGray, myNoneSwatch, 0
	Rem Create a headline text frame.
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(.25,0,1,11.111), "Timing Panel - Timing Groups and Delays", "Myriad Pro", 28, idJustification.idCenterAlign, false
	Rem Add text labels.
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(1.25,1,1.625,10.5), "A-1", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(2.25,1,2.625,10.5), "A-2", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(3.25,1,3.625,10.5), "A-3", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(4.25,1,4.625,10.5), "A-4", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(5.25,1,5.625,10.5), "B-1", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(6.25,1,6.625,10.5), "B-2", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(7.25,1,7.625,10.5), "B-3", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(1.25,5,1.625,10.5), "C-1", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(2.25,5,2.625,10.5), "C-2", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(3.25,5,3.625,10.5), "C-3", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(4.25,5,4.625,10.5), "C-4", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(5.25,5,5.625,10.5), "C-5", "Myriad Pro", 18, idJustification.idLeftAlign, True
	Rem Add rectangles.
	Set myRectangle1P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(1.625,1,2,2), "A-1", myPurple, myNoneSwatch, 0)
	Set myRectangle2P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(2.625,1,3,2), "A-2", myPurple, myNoneSwatch, 0)
	Set myRectangle3P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(3.625,1,4,2), "A-3", myPurple, myNoneSwatch, 0)
	Set myRectangle4P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(4.625,1,5,2), "A-4", myPurple, myNoneSwatch, 0)
	Set myRectangle5P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(5.625,1,6,2), "B-1", myGreen, myNoneSwatch, 0)
	Set myRectangle6P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(6.625,1,7,2), "B-2", myGreen, myNoneSwatch, 0)
	Set myRectangle7P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(7.625,1,8,2), "B-3", myGreen, myNoneSwatch, 0)
	Set myRectangle8P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(1.625,5,2,6), "C-1", myBlue, myNoneSwatch, 0)
	Set myRectangle9P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(2.625,5,3,6), "C-2", myBlue, myNoneSwatch, 0)
	Set myRectangle10P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(3.625,5,4,6), "C-3", myBlue, myNoneSwatch, 0)
	Set myRectangle11P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(4.625,5,5,6), "C-4", myBlue, myNoneSwatch, 0)
	Set myRectangle12P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(5.625,5,6,6), "C-5", myBlue, myNoneSwatch, 0)
	Rem Animation settings (note that you cannot use a page item as the target of a timing group
	Rem if you have not applied animation settings to the it).
	myRectangle1P5.AnimationSettings.Preset = myMotionPreset
	myRectangle2P5.AnimationSettings.Preset = myMotionPreset
	myRectangle3P5.AnimationSettings.Preset = myMotionPreset
	myRectangle4P5.AnimationSettings.Preset = myMotionPreset
	myRectangle5P5.AnimationSettings.Preset = myMotionPreset
	myRectangle6P5.AnimationSettings.Preset = myMotionPreset
	myRectangle7P5.AnimationSettings.Preset = myMotionPreset
	myRectangle8P5.AnimationSettings.Preset = myMotionPreset
	myRectangle9P5.AnimationSettings.Preset = myMotionPreset
	myRectangle10P5.AnimationSettings.Preset = myMotionPreset
	myRectangle11P5.AnimationSettings.Preset = myMotionPreset
	myRectangle12P5.AnimationSettings.Preset = myMotionPreset
	Rem Page 5 timing section:
	Set myFifthSpreadTimingSettings = myRectangle1P5.parent.TimingSettings
	myFifthSpreadTimingSettings.TimingLists.item(1).Delete
	Set myFifthPageLoadTimingList = myFifthSpreadTimingSettings.TimingLists.Add(idDynamicTriggerEvents.idOnPageLoad)
	Rem A group.
	Set myFifthSpreadTimingG1 = myFifthPageLoadTimingList.TimingGroups.Add(myRectangle1P5, 0)
	myFifthSpreadTimingG1.TimingTargets.Add myRectangle2P5, 0
	myFifthSpreadTimingG1.TimingTargets.Add myRectangle3P5, 0
	myFifthSpreadTimingG1.TimingTargets.Add myRectangle4P5, 0
	Rem B group.
	Set myFifthSpreadTimingG2 = myFifthPageLoadTimingList.TimingGroups.Add(myRectangle5P5, 1)
	myFifthSpreadTimingG2.TimingTargets.Add myRectangle6P5,.5
	myFifthSpreadTimingG2.TimingTargets.Add myRectangle7P5, 1
	Rem Enable Group Loop
	myFifthSpreadTimingG2.PlaysLoop = True
	Rem C group.
	Set myFifthSpreadTimingG3 = myFifthPageLoadTimingList.TimingGroups.Add(myRectangle8P5, .25)
	myFifthSpreadTimingG3.TimingTargets.Add myRectangle9P5, .25
	myFifthSpreadTimingG3.TimingTargets.Add myRectangle10P5, .25
	myFifthSpreadTimingG3.TimingTargets.Add myRectangle11P5, .25
	myFifthSpreadTimingG3.TimingTargets.Add myRectangle12P5, .25
	Rem Enable Group Plays 2
	myFifthSpreadTimingG3.Plays = 2
	Rem 
	Rem Page 6
	Rem 
	myDocument.pages.add()
	Rem Create a background rectangle.
	myMakeRectangle myDocument.Pages.Item(6), Array(0,0,8.333,11.111), "Background Rectangle", myLightGray, myNoneSwatch, 0
	Rem Create a headline text frame.
	myMakeTextFrame myInDesign, myDocument.Pages.Item(6), Array(.25,0,1,11.111), "Scripted Animation with Multiple Property Changes", "Myriad Pro", 28, idJustification.idCenterAlign, false
	Rem Add text label.
	myMakeTextFrame myInDesign, myDocument.Pages.Item(6), Array(1.25,1,1.625,10.5), "6-Second Animation with one or more property changes per second", "Myriad Pro", 18, idJustification.idLeftAlign, True
	Rem Add rectangle.
	Set myRectangle1P6 = myMakeRectangle(myDocument.Pages.Item(6), Array(1.625,1,2,2), "Scripted Animation Rectangle", myPurple, myNoneSwatch, 0)
	Rem Set duration before adding keyframes when scripting animations
	myRectangle1P6.AnimationSettings.duration = 6
	Rem Assumes 24 Frames Per Second (FPS)
	Rem 23 = 1 second, 47 = 2 seconds, 71 = 3 seconds, 95 = 4 seconds, 119 = 5 seconds, 143 = 6 seconds
	mySetUnits myInDesign, idMeasurementUnits.idPoints
	Rem Note that the animation here is created with motionPath, which allows for setting keyframes that correspond to points in the path
	myRectangle1P6.AnimationSettings.MotionPath = Array(Array(0, Array(Array(0, 0), Array(0, 0), Array(0, 0))), Array(23, Array(Array(200, 0), Array(200, 0), Array(200, 0))), Array(47, Array(Array(200, 200), Array(200, 200), Array(200, 200))), Array(119, Array(Array(0, 200), Array(0, 200), Array(0, 200))), Array(143, Array(Array(0, 0), Array(0, 0), Array(0, 0))))
	mySetUnits myInDesign, idMeasurementUnits.idInches
	Rem Note that this animation allows setting multiple changes in opacity, scale and rotation that 
	Rem correspond to points in the motion path.  This functionality is not available in the Animation panel UI.
	myRectangle1P6.AnimationSettings.RotationArray =  Array(Array(0, 0), Array(23, 180), Array(47, 0), Array(71, -180), Array(95, 0), Array(119, 180), Array(143, -360))
	myRectangle1P6.AnimationSettings.ScaleXArray = Array( Array(0, 100.0 ), Array(23, 200.0), Array(47, 100.0), Array(71, 300.0), Array(95, 100.0), Array(119, 200.0), Array(143, 100.0) )
	myRectangle1P6.AnimationSettings.ScaleYArray = Array( Array(0, 100.0 ), Array(23, 0.0), Array(47, 100.0), Array(71, 0.0), Array(95, 100.0), Array(119, 300.0), Array(143, 100.0) )
	myRectangle1P6.AnimationSettings.OpacityArray = Array( Array(0, 100.0 ), Array(23, 0.0), Array(47, 100.0), Array(71, 0.0), Array(95, 100.0), Array(119, 0.0), Array(143, 100.0) ) 
	myRectangle1P6.AnimationSettings.Plays = 1
	myRectangle1P6.AnimationSettings.PlaysLoop = False
	myRectangle1P6.AnimationSettings.EaseType = idAnimationEaseOptions.idNoEase
	myRectangle1P6.AnimationSettings.TransformOffsets = Array(0.5, 0.5)
	myRectangle1P6.AnimationSettings.DesignOption = idDesignOptions.idFromCurrentAppearance 
	myRectangle1P6.AnimationSettings.InitiallyHidden = False
	myRectangle1P6.AnimationSettings.HiddenAfter = False		
End Function
Rem Utility functions.
Function mySetUnits(myInDesign, myUnits)
	myInDesign.Documents.Item(1).ViewPreferences.HorizontalMeasurementUnits = myUnits
	myInDesign.Documents.Item(1).ViewPreferences.VerticalMeasurementUnits = myUnits
End Function
Function myMakeTextFrame(myInDesign, myPage, myBounds, myString, myFontName, myPointSize, myJustification, myFitToContent)
	Set myTextFrame = myPage.TextFrames.Add
	myTextFrame.GeometricBounds = myBounds
	myTextFrame.Texts.Item(1).InsertionPoints.Item(1).Contents = myString
	myTextFrame.Texts.Item(1).ParentStory.AppliedFont = myInDesign.Fonts.Item(myFontName)
	myTextFrame.Texts.Item(1).ParentStory.PointSize = myPointSize
	myTextFrame.Texts.Item(1).ParentStory.FillColor = myInDesign.Documents.Item(1).Swatches.Item("Black")
	myTextFrame.Texts.Item(1).Justification = myJustification
	If myFitToContent = True Then
		myTextFrame.Fit idFitOptions.idFrameToContent
	End If
	Set myMakeTextFrame = myTextFrame
End Function
Function myMakeRectangle(myPage, myBounds, myString, myFillColor,  myStrokeColor, myStrokeWeight)
	Set myRectangle = myPage.rectangles.Add
	myRectangle.GeometricBounds = myBounds
	myRectangle.fillColor = myFillColor
	myRectangle.strokeWeight = myStrokeWeight
	myRectangle.strokeColor = myStrokeColor
	myRectangle.name = myString
	Set myMakeRectangle = myRectangle
End Function
Function myMakeColor(myInDesign, myColorName, myColorSpace, myColorModel, myColorValue)
	Set myDocument = myInDesign.Documents.Item(1)
	Rem Something like a try...catch for VBScript.
    On Error Resume Next
    Set myColor = myDocument.Colors.Item(myColorName)
    If Err.Number <> 0 Then
        Set myColor = myDocument.Colors.Add
    End If
    Err.Clear
    On Error GoTo 0
	myColor.Name = myColorName
	myColor.Space = myColorSpace
	myColor.Model = myColorModel
	myColor.ColorValue = myColorValue
	Set myMakeColor = myColor
End Function

'' SIG '' Begin signature block
'' SIG '' MIIeUwYJKoZIhvcNAQcCoIIeRDCCHkACAQExDzANBglg
'' SIG '' hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
'' SIG '' BgEEAYI3AgEeMCQCAQEEEE7wKRaZJ7VNj+Ws4Q8X66sC
'' SIG '' AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
'' SIG '' YlECEgOucUODFLrW6xdSOvxr6AbNRrkZxN1hWPqmTmag
'' SIG '' ggyUMIIF0DCCBLigAwIBAgIQB3XcWt35KITbGdVVTAfs
'' SIG '' STANBgkqhkiG9w0BAQsFADBsMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSswKQYDVQQDEyJEaWdpQ2Vy
'' SIG '' dCBFViBDb2RlIFNpZ25pbmcgQ0EgKFNIQTIpMB4XDTE5
'' SIG '' MDEzMTAwMDAwMFoXDTIxMDIwMzEyMDAwMFowgeYxEzAR
'' SIG '' BgsrBgEEAYI3PAIBAxMCVVMxGTAXBgsrBgEEAYI3PAIB
'' SIG '' AhMIRGVsYXdhcmUxHTAbBgNVBA8MFFByaXZhdGUgT3Jn
'' SIG '' YW5pemF0aW9uMRAwDgYDVQQFEwcyNzQ4MTI5MQswCQYD
'' SIG '' VQQGEwJVUzELMAkGA1UECBMCY2ExETAPBgNVBAcTCFNh
'' SIG '' biBKb3NlMRMwEQYDVQQKEwpBZG9iZSBJbmMuMSwwKgYD
'' SIG '' VQQLEyNJbGx1c3RyYXRvciwgSW5EZXNpZ24sIEluQ29w
'' SIG '' eSwgTXVzZTETMBEGA1UEAxMKQWRvYmUgSW5jLjCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIiKXEE3
'' SIG '' 5FJAWPRPxAu4g1GRRZmzrPW3SZL40s8opqkFWksx2dBE
'' SIG '' yP6+N6visRXUyDy+I979oO9tEtHBeYKx1XHy4NOLPl3u
'' SIG '' Lr8rWv5E3hrNw+QRwJvsMJLzBTS44811Rym8ddkt8lpj
'' SIG '' dG1PmC2aZQ73miR88+46IaZDtuabo3corXvrG0wmLFZb
'' SIG '' SrB80HAigwQiwHgh33cI2pPIYA2VdmEv5V3iI+AuYybL
'' SIG '' BPJ32YPqdvcoR3Ml/oYFcFlUb1sliNdngwqEeUTKBWVu
'' SIG '' OTeuRo2gOioizpUxR3cce25eoH8wONWUozkjPwcUEY8I
'' SIG '' RCePRf21c4kjjLGFSmpwEVQVQJcCAwEAAaOCAfEwggHt
'' SIG '' MB8GA1UdIwQYMBaAFI/ofvBtMmoABSPHcJdqOpD/a+rU
'' SIG '' MB0GA1UdDgQWBBSVoz2+cIajBhNjiGb0VJBYxDX9vzAu
'' SIG '' BgNVHREEJzAloCMGCCsGAQUFBwgDoBcwFQwTVVMtREVM
'' SIG '' QVdBUkUtMjc0ODEyOTAOBgNVHQ8BAf8EBAMCB4AwEwYD
'' SIG '' VR0lBAwwCgYIKwYBBQUHAwMwewYDVR0fBHQwcjA3oDWg
'' SIG '' M4YxaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0VWQ29k
'' SIG '' ZVNpZ25pbmdTSEEyLWcxLmNybDA3oDWgM4YxaHR0cDov
'' SIG '' L2NybDQuZGlnaWNlcnQuY29tL0VWQ29kZVNpZ25pbmdT
'' SIG '' SEEyLWcxLmNybDBLBgNVHSAERDBCMDcGCWCGSAGG/WwD
'' SIG '' AjAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
'' SIG '' Y2VydC5jb20vQ1BTMAcGBWeBDAEDMH4GCCsGAQUFBwEB
'' SIG '' BHIwcDAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGln
'' SIG '' aWNlcnQuY29tMEgGCCsGAQUFBzAChjxodHRwOi8vY2Fj
'' SIG '' ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRFVkNvZGVT
'' SIG '' aWduaW5nQ0EtU0hBMi5jcnQwDAYDVR0TAQH/BAIwADAN
'' SIG '' BgkqhkiG9w0BAQsFAAOCAQEADtCQA7go0Xu2UKN6dFPe
'' SIG '' YJbS/OXx3n3IP0K9CGPDozeGV62MvbCp+DuptFa44FYR
'' SIG '' ZuljRXMxCjsjJmkJLD9Hhuik+a23iSwfOAnWK6AY/VoD
'' SIG '' ZatWvGG6mZzMRs/s5Whztt8IRxLMrLbA+ulDkDKTlqqf
'' SIG '' BWN8xAM23VX2IMmPYFXMf1TgyT3rCr2oontG6eWT0VYa
'' SIG '' j8DrYJuWtoNQaHIxSg3lGWyvqi1RwJc7GjVwJObnRCTH
'' SIG '' Faqmfxwry/5jEDjPNNUyDiMWIr2xxCbe5pu759mb9Hjl
'' SIG '' rSakmU9AhIxEURqKA3wmnF9Sw+OnazRGp4bvfkCeWDtK
'' SIG '' LdN4JKj5eh21hDCCBrwwggWkoAMCAQICEAPxtOFfOoLx
'' SIG '' FJZ4s9fYR1wwDQYJKoZIhvcNAQELBQAwbDELMAkGA1UE
'' SIG '' BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcG
'' SIG '' A1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTErMCkGA1UEAxMi
'' SIG '' RGlnaUNlcnQgSGlnaCBBc3N1cmFuY2UgRVYgUm9vdCBD
'' SIG '' QTAeFw0xMjA0MTgxMjAwMDBaFw0yNzA0MTgxMjAwMDBa
'' SIG '' MGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
'' SIG '' dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20x
'' SIG '' KzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2lnbmlu
'' SIG '' ZyBDQSAoU0hBMikwggEiMA0GCSqGSIb3DQEBAQUAA4IB
'' SIG '' DwAwggEKAoIBAQCnU/oPsrUT8WTPhID8roA10bbXx6Ms
'' SIG '' rBosrPGErDo1EjqSkbpX5MTJ8y+oSDy31m7clyK6UXlh
'' SIG '' r0MvDbebtEkxrkRYPqShlqeHTyN+w2xlJJBVPqHKI3zF
'' SIG '' QunEemJFm33eY3TLnmMl+ISamq1FT659H8gTy3WbyeHh
'' SIG '' ivgLDJj0yj7QRap6HqVYkzY0visuKzFYZrQyEJ+d8FKh
'' SIG '' 7+g+03byQFrc+mo9G0utdrCMXO42uoPqMKhM3vELKlhB
'' SIG '' iK4AiasD0RaCICJ2615UOBJi4dJwJNvtH3DSZAmALeK2
'' SIG '' nc4f8rsh82zb2LMZe4pQn+/sNgpcmrdK0wigOXn93b89
'' SIG '' OgklAgMBAAGjggNYMIIDVDASBgNVHRMBAf8ECDAGAQH/
'' SIG '' AgEAMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggr
'' SIG '' BgEFBQcDAzB/BggrBgEFBQcBAQRzMHEwJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBJBggr
'' SIG '' BgEFBQcwAoY9aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0SGlnaEFzc3VyYW5jZUVWUm9vdENB
'' SIG '' LmNydDCBjwYDVR0fBIGHMIGEMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMIIBxAYDVR0gBIIBuzCC
'' SIG '' AbcwggGzBglghkgBhv1sAwIwggGkMDoGCCsGAQUFBwIB
'' SIG '' Fi5odHRwOi8vd3d3LmRpZ2ljZXJ0LmNvbS9zc2wtY3Bz
'' SIG '' LXJlcG9zaXRvcnkuaHRtMIIBZAYIKwYBBQUHAgIwggFW
'' SIG '' HoIBUgBBAG4AeQAgAHUAcwBlACAAbwBmACAAdABoAGkA
'' SIG '' cwAgAEMAZQByAHQAaQBmAGkAYwBhAHQAZQAgAGMAbwBu
'' SIG '' AHMAdABpAHQAdQB0AGUAcwAgAGEAYwBjAGUAcAB0AGEA
'' SIG '' bgBjAGUAIABvAGYAIAB0AGgAZQAgAEQAaQBnAGkAQwBl
'' SIG '' AHIAdAAgAEMAUAAvAEMAUABTACAAYQBuAGQAIAB0AGgA
'' SIG '' ZQAgAFIAZQBsAHkAaQBuAGcAIABQAGEAcgB0AHkAIABB
'' SIG '' AGcAcgBlAGUAbQBlAG4AdAAgAHcAaABpAGMAaAAgAGwA
'' SIG '' aQBtAGkAdAAgAGwAaQBhAGIAaQBsAGkAdAB5ACAAYQBu
'' SIG '' AGQAIABhAHIAZQAgAGkAbgBjAG8AcgBwAG8AcgBhAHQA
'' SIG '' ZQBkACAAaABlAHIAZQBpAG4AIABiAHkAIAByAGUAZgBl
'' SIG '' AHIAZQBuAGMAZQAuMB0GA1UdDgQWBBSP6H7wbTJqAAUj
'' SIG '' x3CXajqQ/2vq1DAfBgNVHSMEGDAWgBSxPsNpA/i/RwHU
'' SIG '' mCYaCALvY2QrwzANBgkqhkiG9w0BAQsFAAOCAQEAGTNK
'' SIG '' DIEzN9utNsnkyTq7tRsueqLi9ENCF56/TqFN4bHb6YHd
'' SIG '' nwHy5IjV6f4J/SHB7F2A0vDWwUPC/ncr2/nXkTPObNWy
'' SIG '' GTvmLtbJk0+IQI7N4fV+8Q/GWVZy6OtqQb0c1UbVfEnK
'' SIG '' ZjgVwb/gkXB3h9zJjTHJDCmiM+2N4ofNiY0/G//V4BqX
'' SIG '' i3zabfuoxrI6Zmt7AbPN2KY07BIBq5VYpcRTV6hg5ucC
'' SIG '' EqC5I2SiTbt8gSVkIb7P7kIYQ5e7pTcGr03/JqVNYUvs
'' SIG '' RkG4Zc64eZ4IlguBjIo7j8eZjKMqbphtXmHGlreKuWEt
'' SIG '' k7jrDgRD1/X+pvBi1JlqpcHB8GSUgDGCERcwghETAgEB
'' SIG '' MIGAMGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
'' SIG '' Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
'' SIG '' b20xKzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2ln
'' SIG '' bmluZyBDQSAoU0hBMikCEAd13Frd+SiE2xnVVUwH7Ekw
'' SIG '' DQYJYIZIAWUDBAIBBQCggZwwGQYJKoZIhvcNAQkDMQwG
'' SIG '' CisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisG
'' SIG '' AQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEIF4Rf9/AW3P1
'' SIG '' DZL14T/VvwDk/SmJvcGJebTCW6ObSsrCMDAGCisGAQQB
'' SIG '' gjcCAQwxIjAgoB6AHABBAGQAbwBiAGUAIABJAG4ARABl
'' SIG '' AHMAaQBnAG4wDQYJKoZIhvcNAQEBBQAEggEAV2YwoHyP
'' SIG '' 0d5DmoDtCf8bB8OPCG8a/zUCr/DySvMelf3gfAd6NcLl
'' SIG '' 8lt4h7sbWmHh0Vw8RWRrec1q5cklBW2RtzQ1zzfv5D6n
'' SIG '' VcjPG+7LRDl2u8iVd3SJRbIO9xAC3f62DvX0bp83Nnet
'' SIG '' SrK1Z45yxXXgts6q2znf5xRwwXWPtpKDJJwbq5kTvHdl
'' SIG '' SmsL7HzNCXDAPrWCMF0LK+dOgk/C7KRWNuFyG67Fdgnv
'' SIG '' aDhcvu1MCiicktTky7t8+TTY2K0oHcBB2uQkoxcz0CMT
'' SIG '' HGelfFNkwgLc1wtlbv+GZf+YkRlRksJXHXhMmdc5uGfD
'' SIG '' eJm3vRlSPh5jqrCndVmOct25a6GCDsgwgg7EBgorBgEE
'' SIG '' AYI3AwMBMYIOtDCCDrAGCSqGSIb3DQEHAqCCDqEwgg6d
'' SIG '' AgEDMQ8wDQYJYIZIAWUDBAIBBQAwdwYLKoZIhvcNAQkQ
'' SIG '' AQSgaARmMGQCAQEGCWCGSAGG/WwHATAxMA0GCWCGSAFl
'' SIG '' AwQCAQUABCBS6EtkO13dFXCULP56Q2lsbchT0RPgFGCS
'' SIG '' x5RtMC1NlwIQWp0FV9svhk5aA3cIQxIXzBgPMjAyMDEw
'' SIG '' MDQwMDIyMjZaoIILuzCCBoIwggVqoAMCAQICEATNP4Vo
'' SIG '' rnbGG7D+cWDMp20wDQYJKoZIhvcNAQELBQAwcjELMAkG
'' SIG '' A1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZ
'' SIG '' MBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UE
'' SIG '' AxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIFRpbWVz
'' SIG '' dGFtcGluZyBDQTAeFw0xOTEwMDEwMDAwMDBaFw0zMDEw
'' SIG '' MTcwMDAwMDBaMEwxCzAJBgNVBAYTAlVTMRcwFQYDVQQK
'' SIG '' Ew5EaWdpQ2VydCwgSW5jLjEkMCIGA1UEAxMbVElNRVNU
'' SIG '' QU1QLVNIQTI1Ni0yMDE5LTEwLTE1MIIBIjANBgkqhkiG
'' SIG '' 9w0BAQEFAAOCAQ8AMIIBCgKCAQEA6WQ1nPqpmGVkG+QX
'' SIG '' 3LgpNsxnCViFTTDgyf/lOzwRKFCvBzHiXQkYwvaJjGkI
'' SIG '' BCPgdy2dFeW46KFqjv/UrtJ6Fu/4QbUdOXXBzy+nrEV+
'' SIG '' lG2sAwGZPGI+fnr9RZcxtPq32UI+p1Wb31pPWAKoMmki
'' SIG '' E76Lgi3GmKtrm7TJ8mURDHQNsvAIlnTE6LJIoqEUpfj6
'' SIG '' 4YlwRDuN7/uk9MO5vRQs6wwoJyWAqxBLFhJgC2kijE7N
'' SIG '' xtWyZVkh4HwsEo1wDo+KyuDT17M5d1DQQiwues6cZ3o4
'' SIG '' d1RA/0+VBCDU68jOhxQI/h2A3dDnK3jqvx9wxu5CFlM2
'' SIG '' RZtTGUlinXoCm5UUowIDAQABo4IDODCCAzQwDgYDVR0P
'' SIG '' AQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0lAQH/
'' SIG '' BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCC
'' SIG '' AaEGCWCGSAGG/WwHATCCAZIwKAYIKwYBBQUHAgEWHGh0
'' SIG '' dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwggFkBggr
'' SIG '' BgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABv
'' SIG '' AGYAIAB0AGgAaQBzACAAQwBlAHIAdABpAGYAaQBjAGEA
'' SIG '' dABlACAAYwBvAG4AcwB0AGkAdAB1AHQAZQBzACAAYQBj
'' SIG '' AGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAA
'' SIG '' RABpAGcAaQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABh
'' SIG '' AG4AZAAgAHQAaABlACAAUgBlAGwAeQBpAG4AZwAgAFAA
'' SIG '' YQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBo
'' SIG '' AGkAYwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwA
'' SIG '' aQB0AHkAIABhAG4AZAAgAGEAcgBlACAAaQBuAGMAbwBy
'' SIG '' AHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
'' SIG '' eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9
'' SIG '' bAMVMB8GA1UdIwQYMBaAFPS24SAd/imu0uRhpbKiJbLI
'' SIG '' FzVuMB0GA1UdDgQWBBRWUw/BxgenTdfYbldygFBM5Oye
'' SIG '' wTBxBgNVHR8EajBoMDKgMKAuhixodHRwOi8vY3JsMy5k
'' SIG '' aWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLXRzLmNybDAy
'' SIG '' oDCgLoYsaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3No
'' SIG '' YTItYXNzdXJlZC10cy5jcmwwgYUGCCsGAQUFBwEBBHkw
'' SIG '' dzAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNl
'' SIG '' cnQuY29tME8GCCsGAQUFBzAChkNodHRwOi8vY2FjZXJ0
'' SIG '' cy5kaWdpY2VydC5jb20vRGlnaUNlcnRTSEEyQXNzdXJl
'' SIG '' ZElEVGltZXN0YW1waW5nQ0EuY3J0MA0GCSqGSIb3DQEB
'' SIG '' CwUAA4IBAQAug6FEBUoE47kyUvrZgfAau/gJjSO5PdiS
'' SIG '' oeZGHEovbno8Y243F6Mav1gjskOclINOOQmwLOjH4eLM
'' SIG '' 7ct5a87eIwFH7ZVUgeCAexKxrwKGqTpzav74n8GN0SGM
'' SIG '' 5CmCw4oLYAACnR9HxJ+0CmhTf1oQpvgi5vhTkjFf2IKD
'' SIG '' LW0TQq6DwRBOpCT0R5zeDyJyd1x/T+k5mCtXkkTX726T
'' SIG '' 2UPHBDNjUTdWnkcEEcOjWFQh2OKOVtdJP1f8Cp8jXnv0
'' SIG '' lI3dnRq733oqptJFplUMj/ZMivKWz4lG3DGykZCjXzMw
'' SIG '' YFX1/GswrKHt5EdOM55naii1TcLtW5eC+MupCGxTCbT3
'' SIG '' MIIFMTCCBBmgAwIBAgIQCqEl1tYyG35B5AXaNpfCFTAN
'' SIG '' BgkqhkiG9w0BAQsFADBlMQswCQYDVQQGEwJVUzEVMBMG
'' SIG '' A1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
'' SIG '' ZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBB
'' SIG '' c3N1cmVkIElEIFJvb3QgQ0EwHhcNMTYwMTA3MTIwMDAw
'' SIG '' WhcNMzEwMTA3MTIwMDAwWjByMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2Vy
'' SIG '' dCBTSEEyIEFzc3VyZWQgSUQgVGltZXN0YW1waW5nIENB
'' SIG '' MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
'' SIG '' vdAy7kvNj3/dqbqCmcU5VChXtiNKxA4HRTNREH3Q+X1N
'' SIG '' aH7ntqD0jbOI5Je/YyGQmL8TvFfTw+F+CNZqFAA49y4e
'' SIG '' O+7MpvYyWf5fZT/gm+vjRkcGGlV+Cyd+wKL1oODeIj8O
'' SIG '' /36V+/OjuiI+GKwR5PCZA207hXwJ0+5dyJoLVOOoCXFr
'' SIG '' 4M8iEA91z3FyTgqt30A6XLdR4aF5FMZNJCMwXbzsPGBq
'' SIG '' rC8HzP3w6kfZiFBe/WZuVmEnKYmEUeaC50ZQ/ZQqLKfk
'' SIG '' dT66mA+Ef58xFNat1fJky3seBdCEGXIX8RcG7z3N1k3v
'' SIG '' BkL9olMqT4UdxB08r8/arBD13ays6Vb/kwIDAQABo4IB
'' SIG '' zjCCAcowHQYDVR0OBBYEFPS24SAd/imu0uRhpbKiJbLI
'' SIG '' FzVuMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6enIZ3z
'' SIG '' bcgPMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/
'' SIG '' BAQDAgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMIMHkGCCsG
'' SIG '' AQUFBwEBBG0wazAkBggrBgEFBQcwAYYYaHR0cDovL29j
'' SIG '' c3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRw
'' SIG '' Oi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRB
'' SIG '' c3N1cmVkSURSb290Q0EuY3J0MIGBBgNVHR8EejB4MDqg
'' SIG '' OKA2hjRodHRwOi8vY3JsNC5kaWdpY2VydC5jb20vRGln
'' SIG '' aUNlcnRBc3N1cmVkSURSb290Q0EuY3JsMDqgOKA2hjRo
'' SIG '' dHRwOi8vY3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRB
'' SIG '' c3N1cmVkSURSb290Q0EuY3JsMFAGA1UdIARJMEcwOAYK
'' SIG '' YIZIAYb9bAACBDAqMCgGCCsGAQUFBwIBFhxodHRwczov
'' SIG '' L3d3dy5kaWdpY2VydC5jb20vQ1BTMAsGCWCGSAGG/WwH
'' SIG '' ATANBgkqhkiG9w0BAQsFAAOCAQEAcZUS6VGHVmnN793a
'' SIG '' fKpjerN4zwY3QITvS4S/ys8DAv3Fp8MOIEIsr3fzKx8M
'' SIG '' IVoqtwU0HWqumfgnoma/Capg33akOpMP+LLR2HwZYuhe
'' SIG '' giUexLoceywh4tZbLBQ1QwRostt1AuByx5jWPGTlH0gQ
'' SIG '' GF+JOGFNYkYkh2OMkVIsrymJ5Xgf1gsUpYDXEkdws3XV
'' SIG '' k4WTfraSZ/tTYYmo9WuWwPRYaQ18yAGxuSh1t5ljhSKM
'' SIG '' Ycp5lH5Z/IwP42+1ASa2bKXuh1Eh5Fhgm7oMLSttosR+
'' SIG '' u8QlK0cCCHxJrhO24XxCQijGGFbPQTS2Zl22dHv1VjMi
'' SIG '' LyI2skuiSpXY9aaOUjGCAk0wggJJAgEBMIGGMHIxCzAJ
'' SIG '' BgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMx
'' SIG '' GTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNV
'' SIG '' BAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJRCBUaW1l
'' SIG '' c3RhbXBpbmcgQ0ECEATNP4VornbGG7D+cWDMp20wDQYJ
'' SIG '' YIZIAWUDBAIBBQCggZgwGgYJKoZIhvcNAQkDMQ0GCyqG
'' SIG '' SIb3DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDEwMDQw
'' SIG '' MDIyMjZaMCsGCyqGSIb3DQEJEAIMMRwwGjAYMBYEFAMl
'' SIG '' vVBe2pYwLcIvT6AeTCi+KDTFMC8GCSqGSIb3DQEJBDEi
'' SIG '' BCCspetvE8P3K+VTyYmr6AGDbUdTrUyn1ZkbxNzm8IxQ
'' SIG '' czANBgkqhkiG9w0BAQEFAASCAQA+RU1vSEQ47j6i7aWS
'' SIG '' TzdOhMHzuHkghHUGG2E9Zpjn5EPpJu4AhKtsh0bG5yfg
'' SIG '' dzAPSUnrzP3ueZ9j3Wq2Z7F7eYQwz8acCXjgCBETGxu1
'' SIG '' kVCRbPQVQ5hkOIjbUDIxcbVaR4r4NsFbrbZObiaqJy15
'' SIG '' QAgVlAywwCAwCvjH7BPZ6MfIIAMwqOqVPspf4ngBAZXW
'' SIG '' kKBXqLDXHcsHattegWLV0YjNV5ncOUgDiRmBnbB8D9MY
'' SIG '' Ox2pefroHMkULfoolrQDfVQR/4fHJ7P9wElt1C5LP+Q3
'' SIG '' e5k1GlN7JlTm2J4eGcvcW4VmW9isRtbQKL+fb8dL8iMQ
'' SIG '' +85C9aXo6f6ujVZy
'' SIG '' End signature block
